<?php
namespace common\plugins\sms\ihuyi;

use yii;

use common\models\SmsTemplateModel;

use common\library\Basewind;
use common\library\Language;
use common\plugins\BaseSms;

/**
 * @Id ihuyi.plugin.php 2025.7.5 $
 * @author ihuyi
 */

class Ihuyi extends BaseSms
{
    /**
	 * 网关地址
	 * @var string $gateway
	 */
    protected $gateway = 'https://api.ihuyi.com/sms/Submit.json';
    
	/**
     * 短信实例
	 * @var string $code
	 */
    protected $code = 'ihuyi';
    protected $smbaostatus = [
        "0" => "提交失败",
        "2" => "短信发送成功",
        "401" => "APIID不能为空",
        "402" => "APIKEY不能为空",
        "403" => "手机号码不能为空",
        "405" => "APIID 或 APIKEY 不正确",
        "4051" => "剩余条数不足",
        "4052" => "访问 ip 与备案 ip 不符",
        "406" => "手机格式不正确",
        "407" => "短信内容含有敏感字符",
        "4070" => "签名格式不正确"
];
    
    /**
	 * 发送短信
     * @param bool $valid 发送频次等的校验，如果是系统发送的短信，可以适当的不做该校验以确保发送成功
	 */
	public function send($valid = true)
	{
        if(!$this->verify()) {
            return false;
        }
      
        if($valid === true && !$this->validSend()) {
            return false;
        }
        
        // 发送的短信信息校验
        if($this->validData() == false) {
            return false;
        }
  
        $result = $this->submit();
        if($result == '2') {
            $codekey = $this->insert($result);
            return $codekey;
        }

        $this->errors = $this->smbaostatus[$result];
        $this->insert(0, $this->errors);
        return false;
    }

    /**
     * 测试短信发送
     */
    public function testsend($content = '') {
        $this->content = $content;
        $result = $this->submit();
        if($result == '2') {
            return true;
        }

        $this->errors = $this->smbaostatus[$result];
        return false;
    }
    
    /**
     * 执行短信发生
     */
    private function submit()
    {
        $url = $this->gateway.'?account='.$this->config['uid'].'&password='.$this->config['ApiKey'] .
        '&mobile=' . $this->receiver . '&content=' . urlencode($this->content);
        $res = Basewind::curl($url);
        if ($res) {
            $result = json_decode($res, true);
            return $result['code'];
        } else {
            return false;
        }
    }

    /**
     * 检测是否配置
     * @var boolean $force 是否验证短信模板内容
     */
    public function verify($force = true)
    {
        if(!$this->config['uid']) {
            $this->errors = '短信设置错误';
            return false;
        }
        if(!$this->config['ApiKey']) {
            $this->errors = '短信设置错误';
            return false;
        }

        // 如果是验证非具体短信场景，可以不用验证短信模板
        // 比如某个地方仅仅需要判断密钥是否配置，从而进行开关控制
        if(!$force) {
            return true;
        }

        // 传递具体短信场景参数，则验证短信模板
        if(($template = $this->getTemplate()) === false) {
            return false;
        }
        if(!$template || empty($template->content)) {
            $this->errors = Language::get('The "content" property must be set');
            return false;
        }
        if(empty($template->signName)) {
            $this->errors = Language::get('The "signName" property must be set');
            return false;
        }

        // 此处为必须赋值，避免无法发送短信
        $this->templateId = $template->templateId;
        $this->signName = $template->signName;
        $this->content = $this->getContent($template);

        return true;
    }
    
}

